/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client;

import com.azul.crs.client.Client;
import com.azul.crs.client.Tweaks;
import com.azul.crs.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public enum Options {
    UnlockExperimentalCRS(null),
    props(Options::readableFile),
    mode(Options::agentMode),
    delayTermination(Options::nonNegativeNumber, "0"),
    maxJarFileCacheSize(Options::nonNegativeNumber, Tweaks.forceFullJarLoadedEvents ? "9999999999" : "20480"),
    stackRecordId(Options::anyString),
    sendPOMData(Options::anyBoolean, "true", "true"),
    sendClassMethods(Options::anyBoolean, "false", "true"),
    notifyJarLoad(Options::anyBoolean, "true", "true"),
    notifyClassLoad(Options::anyBoolean, "true", "true"),
    memorySafeguards(Options::anyBoolean, "true", "true"),
    enable(null),
    lifetimejfr(Options::anyString),
    notifyFirstCall(Options::anyBoolean, "false", "true"),
    delayInitiation(Options::nonNegativeNumber, "2000", "2000"),
    forceSyncTimeout(Options::nonNegativeNumber),
    sendJVMLogs(Options::anyBoolean, "false", "true"),
    sendCRSLogs(Options::anyBoolean, "true", "true"),
    extraLogFile(Options::anyString),
    connectionManager(Options::anyString);

    private static final String DEFAULT_SHARED_PROPS_FILE = "az_crs.properties";
    private static final String DEFAULT_USER_PROPS_FILE;
    private String value;
    private Origin origin;
    private static final Map<Client.ClientProp, Object> clientProps;
    private static Collection<Map.Entry<String, String>> loggerOptions;
    private final BiFunction<Options, String, String> validator;
    private final String defaultValue;
    private final String emptyValue;

    private Options(BiFunction<Options, String, String> biFunction) {
        this(biFunction, null);
    }

    private Options(BiFunction<Options, String, String> biFunction, String string2) {
        this(biFunction, string2, null);
    }

    private Options(BiFunction<Options, String, String> biFunction, String string2, String string3) {
        this.validator = biFunction;
        this.defaultValue = string2;
        this.emptyValue = string3;
    }

    private static String readableFile(Options options, String string) {
        Path path = Paths.get(string, new String[0]);
        if (Files.isReadable(path)) {
            try {
                return path.toFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Bad value '" + string + "'. " + options.name() + " requires valid readable file path.");
    }

    private static String anyBoolean(Options options, String string) {
        switch (string.toLowerCase()) {
            case "on": 
            case "yes": 
            case "true": 
            case "enable": {
                return "true";
            }
            case "off": 
            case "no": 
            case "false": 
            case "disable": {
                return "false";
            }
        }
        throw new IllegalArgumentException("Bad " + options.name() + " option value '" + string + "'. Allowed values: '{yes|no|true|false|on|off|enable|disable}'");
    }

    private static String anyString(Options options, String string) {
        return string;
    }

    private static String agentMode(Options options, String string) {
        String string2;
        switch (string2 = string.toLowerCase()) {
            case "on": 
            case "off": 
            case "auto": {
                return string2;
            }
        }
        throw new IllegalArgumentException("Bad " + options.name() + " option value '" + string + "'. Allowed values: '{on|off|auto}'.");
    }

    private static String nonNegativeNumber(Options options, String string) {
        try {
            if (Long.parseLong(string) >= 0L) {
                return string;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Bad " + options.name() + " option value '" + string + "'. Non-negative number required.");
    }

    public static void checkIntegrity(Predicate<Options> predicate) {
        EnumSet.allOf(Options.class).stream().filter(options -> !predicate.test((Options)((Object)options))).filter(Options::isSet).forEach(options -> Logger.getLogger(Options.class).warning("%s is not supported and ignored", options.name()));
        if (predicate.test(notifyJarLoad) && predicate.test(notifyClassLoad) && notifyJarLoad.isSet() && !notifyJarLoad.isYes() && (!notifyClassLoad.isSet() || notifyClassLoad.isYes())) {
            notifyClassLoad.set("false", Origin.ERGONOMIC);
            Logger.getLogger(Options.class).warning("notifyClassLoad depends on notifyJarLoad and was disabled", new Object[0]);
        }
        if (predicate.test(notifyClassLoad) && predicate.test(notifyFirstCall) && notifyClassLoad.isSet() && !notifyClassLoad.isYes() && (!notifyFirstCall.isSet() || notifyFirstCall.isYes())) {
            notifyFirstCall.set("false", Origin.ERGONOMIC);
            Logger.getLogger(Options.class).warning("notifyFirstCall depends on notifyClassLoad and was disabled", new Object[0]);
        }
        EnumSet.allOf(Options.class).stream().filter(predicate).filter(options -> options.value == null && options.defaultValue != null).forEach(options -> options.set(options.defaultValue, Origin.DEFAULT));
    }

    public static void dump(String string, Predicate<Options> predicate) {
        Logger logger = Logger.getLogger(Options.class);
        if (logger.isEnabled(Logger.Level.DEBUG)) {
            Set set = EnumSet.allOf(Options.class).stream().filter(predicate).filter(Options::isSet).collect(Collectors.toSet());
            Function<Function, Integer> function2 = function -> set.stream().map(function).mapToInt(String::length).max().orElse(0);
            int n = function2.apply(Enum::name);
            int n2 = function2.apply(Options::get);
            int n3 = function2.apply(options -> options.origin.name());
            logger.info("Effective %s options: %s", string, set.stream().sorted(Comparator.comparing(Enum::name)).map(options -> String.format("\n   %-" + n + "s = %" + n2 + "s [ %-" + n3 + "s ]", new Object[]{options.name(), options.value, options.origin})).collect(Collectors.joining()));
            logger.info("Effective %s log configuration: %s", string, loggerOptions.stream().sorted(Map.Entry.comparingByKey()).map(entry -> String.format("\n   %s = %s", entry.getKey(), entry.getValue())).collect(Collectors.joining()));
        }
    }

    private static void updateCrsArgs(Map<String, String> map, Options options) {
        map.put(options.toString(), options.get());
    }

    public static Map<String, String> dumpCrsArgs() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Options.updateCrsArgs(hashMap, mode);
        Options.updateCrsArgs(hashMap, delayTermination);
        Options.updateCrsArgs(hashMap, maxJarFileCacheSize);
        Options.updateCrsArgs(hashMap, sendPOMData);
        Options.updateCrsArgs(hashMap, sendClassMethods);
        Options.updateCrsArgs(hashMap, notifyJarLoad);
        Options.updateCrsArgs(hashMap, notifyClassLoad);
        Options.updateCrsArgs(hashMap, lifetimejfr);
        Options.updateCrsArgs(hashMap, notifyFirstCall);
        Options.updateCrsArgs(hashMap, delayInitiation);
        Options.updateCrsArgs(hashMap, forceSyncTimeout);
        Options.updateCrsArgs(hashMap, sendJVMLogs);
        Options.updateCrsArgs(hashMap, sendCRSLogs);
        hashMap.put("log", loggerOptions.stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(",")));
        return hashMap;
    }

    String get() {
        return this.value;
    }

    boolean isSet() {
        return this.value != null;
    }

    public int getInt() {
        return Integer.parseInt(this.value);
    }

    public long getLong() {
        return Long.parseLong(this.value);
    }

    public boolean isYes() {
        return Boolean.parseBoolean(this.value);
    }

    void set(String string, Origin origin) {
        try {
            this.value = "".equals(string) ? this.emptyValue : (this.validator == null ? string : this.validator.apply(this, string));
            this.origin = origin;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(Options.class).error("%s", illegalArgumentException);
            this.value = this.defaultValue;
            this.origin = Origin.ERGONOMIC;
        }
    }

    static void read(String string) {
        File file;
        String string2 = System.getenv("AZ_CRS_ARGUMENTS");
        String string3 = Options.getPropFileNameFromArgs(string);
        if (string3 == null) {
            string3 = Options.getPropFileNameFromArgs(string2);
        }
        if (string3 != null) {
            file = new File(string3);
            if (!file.exists()) {
                Logger.getLogger(Options.class).error("specified properties file '%s' does not exist", file.getPath());
            }
        } else {
            file = new File(System.getProperty("user.home") + File.separatorChar + DEFAULT_USER_PROPS_FILE);
            if (!file.exists()) {
                file = new File(System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + DEFAULT_SHARED_PROPS_FILE);
            }
        }
        if (file.exists()) {
            Options.tryLoadingProps(file);
        }
        Options.readArgs(string2, Origin.ENVIRONMENT);
        Options.readArgs(string, Origin.COMMANDLINE);
        Logger.parseOptions(loggerOptions);
    }

    private static String getPropFileNameFromArgs(String string) {
        String string2 = null;
        int n = 0;
        if (string != null && string.startsWith("mode=on,")) {
            n += "mode=on,".length();
        }
        if (string != null && string.startsWith("mode=auto,")) {
            n += "mode=auto,".length();
        }
        if (string != null && string.startsWith("failJVMOnError,")) {
            n += "failJVMOnError,".length();
        }
        if (string != null && string.length() > n) {
            int n2;
            int n3 = string.indexOf(44, n);
            if (n3 < 0) {
                n3 = string.length();
            }
            if (string.charAt(n) != ',' && ((n2 = string.indexOf(61, n)) < 0 || n2 > n3)) {
                try {
                    Options.valueOf(string.substring(n, n3));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    string2 = string.substring(n, n3);
                }
            }
            String string3 = props.name() + "=";
            int n4 = string3.length();
            do {
                if ((n3 = string.indexOf(44, n)) < 0) {
                    n3 = string.length();
                }
                if (!string.startsWith(string3, n)) continue;
                string2 = string.substring(n + n4, n3);
                break;
            } while ((n = n3 + 1) < string.length());
        }
        return string2;
    }

    private static void readArgs(String string, Origin origin) {
        int n;
        if (string == null) {
            return;
        }
        int n2 = 0;
        do {
            String string2;
            int n3;
            if ((n = string.indexOf(44, n2)) == -1) {
                n = string.length();
            }
            if ((n3 = string.indexOf(61, n2)) == -1 || n3 > n) {
                n3 = n;
            }
            String string3 = string.substring(n2, n3);
            String string4 = string2 = n3 == n ? "" : string.substring(n3 + 1, n);
            if (props.name().equals(string3)) continue;
            Options.process(string3, string2, n2 == 0 && n3 == n, origin);
        } while ((n2 = n + 1) < string.length());
    }

    private static void process(String string, String string2, boolean bl, Origin origin) {
        block9: {
            if (string.equals("log") || string.startsWith("log+") || string.startsWith("log:")) {
                loggerOptions.add(new AbstractMap.SimpleEntry<String, String>(string, string2));
            } else if (props.name().equals(string)) {
                Options.tryLoadingProps(new File(string2));
            } else if (string.length() > 0) {
                for (Client.ClientProp clientProp : (Client.ClientProp[])Client.ClientProp.class.getEnumConstants()) {
                    if (!clientProp.value().equals(string)) continue;
                    clientProps.put(clientProp, string2);
                    return;
                }
                try {
                    Options.valueOf(string).set(string2, origin);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (bl) break block9;
                    Logger.getLogger(Options.class).error("unrecognized CRS agent option %s ignored", string);
                }
            }
        }
        if (Tweaks.FORCE_TRACE_LOGGING) {
            loggerOptions = new LinkedList<Map.Entry<String, String>>();
            loggerOptions.add(new AbstractMap.SimpleEntry<String, String>("log", "trace+stack+time"));
        }
    }

    private static void tryLoadingProps(File file) {
        Properties properties = new Properties();
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            properties.load(inputStream);
            for (String string : properties.stringPropertyNames()) {
                Options.process(string, properties.getProperty(string), false, Origin.PROPERTIES);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(Options.class).error("cannot load specified properties file %s: %s", file.getPath(), iOException);
        }
    }

    public static Map<Client.ClientProp, Object> getClientProps() {
        return clientProps;
    }

    static {
        DEFAULT_USER_PROPS_FILE = ".az_crs" + File.separatorChar + "config.properties";
        clientProps = new HashMap<Client.ClientProp, Object>();
        loggerOptions = new LinkedList<Map.Entry<String, String>>();
    }

    public static enum Origin {
        DEFAULT,
        COMMANDLINE,
        ENVIRONMENT,
        PROPERTIES,
        ERGONOMIC;

    }
}

