/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.featureflags;

import com.azul.crs.client.featureflags.FeatureFlags;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.util.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class FeatureFlagsConfiguration {
    private static final Logger logger = Logger.getLogger(FeatureFlagsConfiguration.class);
    private static AtomicBoolean notifyJarLoaded = new AtomicBoolean(false);
    private static AtomicBoolean notifyClassLoad = new AtomicBoolean(false);
    private static AtomicBoolean notifyFirstCall = new AtomicBoolean(false);
    private static AtomicBoolean notifyClassMethods = new AtomicBoolean(false);

    public static void initialize(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        notifyJarLoaded = new AtomicBoolean(bl);
        notifyClassLoad = new AtomicBoolean(bl2);
        notifyFirstCall = new AtomicBoolean(bl3);
        notifyClassMethods = new AtomicBoolean(bl4);
    }

    public static boolean notifyJarLoaded() {
        return notifyJarLoaded.get();
    }

    public static boolean notifyClassLoad() {
        return notifyClassLoad.get();
    }

    public static boolean notifyFirstCall() {
        return notifyFirstCall.get();
    }

    public static boolean notifyClassMethods() {
        return notifyClassMethods.get();
    }

    static List<FeatureFlags> update(Set<FeatureFlags> set) {
        HashSet<FeatureFlags.Definition> hashSet = new HashSet<FeatureFlags.Definition>(FeatureFlags.ALL.getDefinition());
        set.forEach(featureFlags -> hashSet.removeAll(featureFlags.getDefinition()));
        hashSet.forEach(definition -> FeatureFlagsConfiguration.getOption(definition).set(false));
        return FeatureFlagsConfiguration.checkIntegrity(set);
    }

    public static List<FeatureFlags> updateFeatureFlags(Collection<String> collection) {
        String string3 = "features=";
        Set<FeatureFlags> set = collection.stream().filter(string2 -> {
            if (string2.startsWith(string3)) {
                return true;
            }
            logger.info("Feature flags configuration contains the invalid line: %s. It will be ignored", string2);
            return false;
        }).flatMap(string2 -> Arrays.stream(string2.replace(string3, "").split("\\+"))).map(string -> FeatureFlags.valueOf(string)).collect(Collectors.toSet());
        if (!set.isEmpty()) {
            List<FeatureFlags> list = FeatureFlagsConfiguration.update(set);
            list.forEach(featureFlags -> logger.info("Feature flag: %s allowed by IC, but an Option is disabled locally.", featureFlags));
            return list;
        }
        return Collections.emptyList();
    }

    private static AtomicBoolean getOption(FeatureFlags.Definition definition) {
        switch (definition) {
            case notifyJarLoad: {
                return notifyJarLoaded;
            }
            case notifyClassLoad: {
                return notifyClassLoad;
            }
            case notifyClassMethods: {
                return notifyClassMethods;
            }
            case notifyFirstCall: {
                return notifyFirstCall;
            }
        }
        throw new RuntimeException("Unknown definition: " + (Object)((Object)definition));
    }

    private static List<FeatureFlags> checkIntegrity(Set<FeatureFlags> set) {
        ArrayList<FeatureFlags> arrayList = new ArrayList<FeatureFlags>();
        for (FeatureFlags featureFlags : set) {
            if (featureFlags.getDefinition().stream().allMatch(definition -> FeatureFlagsConfiguration.getOption(definition).get())) continue;
            arrayList.add(featureFlags);
        }
        return arrayList;
    }

    public static boolean isEnabled(VMEvent.Type type) {
        switch (type) {
            case VM_CLASS_LOADED: {
                return notifyClassLoad.get();
            }
            case VM_METHOD_FIRST_CALLED: {
                return notifyFirstCall.get();
            }
            case VM_JAR_LOADED: {
                return notifyJarLoaded.get();
            }
        }
        return true;
    }
}

