/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.jars;

import com.azul.crs.client.JDKAccessor;
import com.azul.crs.client.Utils;
import com.azul.crs.client.jars.JarSource;
import com.azul.crs.client.jars.VMEventHelper;
import com.azul.crs.client.jars.tracker.JarTracker;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.safeguards.InsufficientMemoryException;
import com.azul.crs.client.safeguards.Reference;
import com.azul.crs.client.safeguards.ReferenceFactory;
import com.azul.crs.client.util.JarAccessUtils;
import com.azul.crs.client.util.ThrowingConsumer;
import com.azul.crs.jar.ZipTools;
import com.azul.crs.runtime.utils.ClassMethodsMap;
import com.azul.crs.runtime.utils.DataEntriesMap;
import com.azul.crs.runtime.utils.TempFilesFactory;
import com.azul.crs.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public class JarAccess {
    private static boolean failedToCalculateDigestNotSent = true;
    final Logger logger = Logger.getLogger(this.getClass());
    private final ReferenceFactory referenceFactory;
    private final String source;
    private InitiatedBy initiatedBy;
    private final JarAccessUtils jarAccessUtils;
    private String hash;
    private ZipTools.JarShortDigest jarShortDigest;
    private Reference<JarEntry> jarEntry;
    private final Reference<JarFile> originJar;
    private final URL url;
    private String path;
    private Reference<JarFile> actualJar;
    private Reference<JarAccess> parent;
    private Reference<Cache> cache;
    private TempFilesFactory.TempFile tempFile;
    private final Reference<JarTracker> tracker;

    public TempFilesFactory.TempFile getTempFile() {
        return this.tempFile;
    }

    public JarAccess(ReferenceFactory referenceFactory, JarAccessUtils jarAccessUtils, JarFile jarFile, JarSource jarSource, String string, InitiatedBy initiatedBy) {
        this(referenceFactory, jarAccessUtils, null, jarFile, jarSource.getUrl(), string, jarSource.getUrl().toString(), initiatedBy, null);
    }

    public JarAccess(ReferenceFactory referenceFactory, JarAccessUtils jarAccessUtils, JarAccess jarAccess, JarFile jarFile, URL uRL, String string, String string2, InitiatedBy initiatedBy, JarEntry jarEntry) {
        this.referenceFactory = referenceFactory;
        this.jarAccessUtils = jarAccessUtils;
        this.originJar = referenceFactory.createNewReference(jarFile);
        this.url = uRL;
        this.actualJar = referenceFactory.createNewReference(jarFile);
        this.path = string;
        this.source = string2;
        this.initiatedBy = initiatedBy;
        this.parent = referenceFactory.createNewReference(jarAccess);
        this.jarEntry = referenceFactory.createNewReference(jarEntry);
        this.tracker = referenceFactory.createNewReference(new JarTracker(jarFile, uRL, string));
        this.cache = referenceFactory.createNewReference(new Cache());
    }

    public void setInitiatedBy(InitiatedBy initiatedBy) {
        this.initiatedBy = initiatedBy;
    }

    public JarTracker getTracker() {
        return this.tracker.get();
    }

    public JarFile getJarFile() {
        return this.actualJar.get();
    }

    EntryAccess entryAccess() {
        if (this.jarEntry.get() == null) {
            return null;
        }
        return new EntryAccess();
    }

    public void withInputStream(ThrowingConsumer<InputStream, Exception> throwingConsumer) {
        if (this.entryAccess() != null) {
            this.entryAccess().withInputStream(throwingConsumer);
        } else {
            this.doWithJarReopen(jarAccess -> throwingConsumer.accept(null));
        }
    }

    public Long requiredTempfsSpace() {
        return this.jarEntry.get() == null ? 0L : this.entryAccess().getSize();
    }

    public String getManifesthash() {
        return this.jarShortDigest == null ? null : Utils.encodeToStringOrNull(this.jarShortDigest.getManifestHash());
    }

    public ZipTools.JarShortDigest getJarShortDigest() {
        if (this.jarShortDigest != null) {
            return this.jarShortDigest;
        }
        try {
            this.referenceFactory.oomSafeRun(() -> {
                this.jarShortDigest = this.jarAccessUtils.calculateJarShortDigest(this);
            });
        }
        catch (Exception exception) {
            if (failedToCalculateDigestNotSent) {
                this.logger.error("Failed to calculate jarShortDigset for (%s) with exception: %s", this, exception);
                failedToCalculateDigestNotSent = false;
            }
            this.logger.warning("Failed to calculate jarShortDigset for (%s) with exception: %s", this, exception);
        }
        return this.jarShortDigest;
    }

    public JarAccess getParentJarAccess() {
        return this.parent.get();
    }

    public String getJarName() {
        return this.tempFile != null ? this.tempFile.getPath() : this.getUnifiedPath();
    }

    public String getUnifiedPath() {
        return !this.getPath().contains("!/") ? this.getPath() : "jar:file:" + this.getPath() + "!/";
    }

    public Cache getCache() {
        return this.cache.get();
    }

    public void acquireResources(TempFilesFactory.TempFile tempFile) throws IOException {
        this.getCache();
        this.tempFile = tempFile;
        if (this.jarEntry.get() != null) {
            this.path = tempFile.getAbsolutePath();
            this.referenceFactory.oomSafeRun(() -> this.withInputStream(inputStream -> Files.copy(inputStream, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING)));
            this.actualJar = this.referenceFactory.createNewReference(new JarFile((File)tempFile, false));
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getHashLazy() {
        return this.hash;
    }

    public String getHash() throws CentralDirectoryHashNotInitializedException {
        if (this.hash != null) {
            return this.hash;
        }
        this.doWithJarReopen(jarAccess -> {
            if (jarAccess == null || jarAccess.getJarShortDigest() == null) {
                throw new CentralDirectoryHashNotInitializedException("unexpected request: jarAccess=" + jarAccess + ", digest=" + (jarAccess != null ? jarAccess.getJarShortDigest() : null));
            }
            this.hash = Utils.encodeToStringOrNull(jarAccess.getJarShortDigest().getCentralDirectoryHash());
        });
        if (this.hash != null) {
            return this.hash;
        }
        throw new CentralDirectoryHashNotInitializedException("central directory hash not initialized yet.");
    }

    public URL getURL() {
        return this.url;
    }

    public String getSource() {
        return this.source;
    }

    public String getUrlOrSourceOrNull() {
        if (this.url != null) {
            return this.url.toString();
        }
        if (this.source != null) {
            return this.source.toString();
        }
        return null;
    }

    public void forEachJarEntry(ThrowingConsumer<JarAccess, Exception> throwingConsumer) {
        this.doWithJarReopen(jarAccess -> {
            for (JarEntry jarEntry : Collections.list(jarAccess.getJarFile().entries())) {
                if (!ZipTools.isJarFile(jarEntry.getName())) continue;
                JarAccess jarAccess2 = new JarAccess(this.referenceFactory, this.jarAccessUtils, this, null, null, this.path + "!/" + jarEntry.getName(), this.source + jarEntry.getName() + "!/", InitiatedBy.RECURSIVE_LOADING, jarEntry);
                throwingConsumer.accept(jarAccess2);
            }
        });
    }

    public void forEachEntry(ThrowingConsumer<EntryAccess, Exception> throwingConsumer) {
        this.doWithJarReopen(jarAccess -> {
            for (JarEntry jarEntry : Collections.list(jarAccess.getJarFile().entries())) {
                if (jarEntry.isDirectory()) continue;
                JarAccess jarAccess2 = new JarAccess(this.referenceFactory, this.jarAccessUtils, this, null, null, this.path + "!/" + jarEntry.getName(), this.source + jarEntry.getName() + "!/", InitiatedBy.RECURSIVE_LOADING, jarEntry);
                throwingConsumer.accept(jarAccess2.entryAccess());
            }
        });
    }

    public void forEachManifestClassPathEntry(ThrowingConsumer<String, Exception> throwingConsumer) {
        this.doWithJarReopen(jarAccess -> {
            File file = new File(jarAccess.getJarFile().getName());
            File file2 = file.getParentFile();
            String string = file2 != null ? file2.getAbsolutePath() + File.separator : "";
            for (String string3 : this.getJarLocalClassPath(this.getJarFile()).stream().map(string2 -> string + string2).collect(Collectors.toList())) {
                throwingConsumer.accept(string3);
            }
        });
    }

    public InitiatedBy getInitiatedBy() {
        return this.initiatedBy;
    }

    public int getNestingLevel() {
        int n = 0;
        for (JarAccess jarAccess = this.parent.get(); n < 99 && jarAccess != null; ++n, jarAccess = jarAccess.getParentJarAccess()) {
        }
        return n;
    }

    public long requiredTempfsSpaceWithParents() {
        return this.requiredTempfsSpace() + (this.parent.get() != null ? this.parent.get().requiredTempfsSpaceWithParents() : 0L);
    }

    public boolean equals(Object object) {
        if (object instanceof JarAccess) {
            return Objects.equals(this.getPath(), ((JarAccess)object).getPath()) && Objects.equals(this.getURL(), ((JarAccess)object).getURL()) && Objects.equals(this.getSource(), ((JarAccess)object).getSource());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.getPath()) ^ Objects.hashCode(this.getURL()) ^ Objects.hashCode(this.getSource());
    }

    private void reopenJar() throws IOException {
        this.logger.trace("reopening jar: %s; by file name: %s", this, this.getJarFile().getName());
        this.actualJar = this.referenceFactory.createNewReference(new JarFile(this.getJarFile().getName(), false));
    }

    private void doWithJarReopen(ThrowingConsumer<JarAccess, Exception> throwingConsumer) {
        int n = 0;
        try {
            Exception exception;
            while (true) {
                exception = null;
                ++n;
                try {
                    this.referenceFactory.oomSafeRunThrowing(() -> throwingConsumer.accept(this));
                }
                catch (InsufficientMemoryException insufficientMemoryException) {
                    throw insufficientMemoryException;
                }
                catch (Exception exception2) {
                    exception = exception2;
                    if (!(exception2 instanceof IOException || exception2 instanceof JDKAccessor.ZipFileInconsistentException || ZipTools.ZipFileClosedException.isZipFileClosedException(exception2))) {
                        throw exception2;
                    }
                    this.reopenJar();
                    if (n < 3) continue;
                }
                break;
            }
            if (exception != null) {
                throw exception;
            }
        }
        catch (InsufficientMemoryException insufficientMemoryException) {
            throw insufficientMemoryException;
        }
        catch (Exception exception) {
            this.logger.debug("doWithJarReopen failed for url=%s after %d attempt with exception=%s", this.getURL(), n, exception);
            throw new RuntimeException("Wrapper:", exception);
        }
    }

    private Collection<String> getJarManifestAttributeAsList(JarFile jarFile, String string) {
        try {
            if (jarFile == null) {
                return Collections.emptyList();
            }
            if (jarFile.getManifest() == null) {
                return Collections.emptyList();
            }
            if (jarFile.getManifest().getMainAttributes() == null) {
                return Collections.emptyList();
            }
            if (jarFile.getManifest().getMainAttributes().getValue(string) == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(jarFile.getManifest().getMainAttributes().getValue(string).split("[ :]"));
        }
        catch (Exception exception) {
            this.logger.debug("Failed to get manifest attributes %s from jar %s due to exception: %s", string, com.azul.crs.client.util.Utils.toStringWithIdentityHash(jarFile), exception);
            return Collections.emptyList();
        }
    }

    private Collection<String> getJarLocalClassPath(JarFile jarFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getJarManifestAttributeAsList(jarFile, "Class-Path"));
        arrayList.addAll(this.getJarManifestAttributeAsList(jarFile, "Boot-Class-Path"));
        return arrayList;
    }

    public String toString() {
        return "JarAccess[parent=" + Objects.toString(this.parent) + ", url=" + this.url + ", originJar=" + this.originJar.get() + ":" + (this.originJar.get() == null ? null : this.originJar.get().getName()) + ", actualJar=" + this.actualJar.get() + ":" + (this.actualJar.get() == null ? null : this.actualJar.get().getName()) + ", className=" + (this.originJar.get() == null ? null : this.originJar.get().getClass().getName()) + ", path=" + this.path + ", source=" + this.source + ", hash=" + this.hash + ", sizeRequired=" + this.requiredTempfsSpace() + ", cache=" + Objects.toString(this.cache.get()) + "]";
    }

    private static Logger logger() {
        return Logger.getLogger(JarAccess.class);
    }

    private class CentralDirectoryHashNotInitializedException
    extends RuntimeException {
        public CentralDirectoryHashNotInitializedException(String string) {
            super(string);
        }
    }

    public static class Cache {
        public VMEvent vmEvent;
        public DataEntriesMap<VMEventHelper.Hashes> entriesMap;
        public ClassMethodsMap classMethodsMap = new ClassMethodsMap();

        private String printEventDetails() {
            if (this.vmEvent == null) {
                return "null";
            }
            if (this.vmEvent.getEventPayload() == null) {
                return "<no-payload>";
            }
            if (!(this.vmEvent.getEventPayload() instanceof Map)) {
                return "<type:" + this.vmEvent.getEventPayload().getClass().getName() + ">";
            }
            Map map = (Map)this.vmEvent.getEventPayload();
            return "[extractionMethod=" + map.get("centralDirectoryExtractionMethod") + ", depth=" + map.get("recursionDepth") + "]";
        }

        public String toString() {
            return "Cache[entries=" + (this.entriesMap == null ? null : Integer.valueOf(this.entriesMap.size())) + ", vmevent/details=" + this.printEventDetails() + "]";
        }
    }

    public class EntryAccess {
        public String getName() {
            return ((JarEntry)JarAccess.this.jarEntry.get()).getName();
        }

        public long getCrc() {
            return ((JarEntry)JarAccess.this.jarEntry.get()).getCrc();
        }

        public void withInputStream(ThrowingConsumer<InputStream, Exception> throwingConsumer) {
            Reference reference = JarAccess.this.jarEntry;
            ((JarAccess)JarAccess.this.parent.get()).doWithJarReopen(jarAccess -> {
                try (InputStream inputStream = jarAccess.getJarFile().getInputStream((ZipEntry)reference.get());){
                    throwingConsumer.accept(inputStream);
                }
            });
        }

        public long getSize() {
            return ((JarEntry)JarAccess.this.jarEntry.get()).getSize();
        }
    }

    public static enum InitiatedBy {
        CLASS_LOADING,
        JDK_NATIVE_LOADING,
        RECURSIVE_LOADING,
        SERVER_REQUEST,
        CLASS_PATH_ENTRY,
        CLASS_PATH_ENTRY_BY_MANIFEST,
        OTHER;

    }
}

