/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.jars;

import com.azul.crs.client.Tweaks;
import com.azul.crs.client.jars.JarAccess;
import com.azul.crs.client.jars.JarCache;
import com.azul.crs.client.jars.JarSource;
import com.azul.crs.client.safeguards.Reference;
import com.azul.crs.client.safeguards.ReferenceFactory;
import com.azul.crs.client.util.JarAccessUtils;
import com.azul.crs.client.util.Utils;
import com.azul.crs.jar.ZipTools;
import com.azul.crs.runtime.utils.URLHelper;
import com.azul.crs.util.logging.Logger;
import java.net.JarURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.jar.JarFile;

public class JarAccessFactory {
    final Logger logger = Logger.getLogger(this.getClass());
    private final ReferenceFactory referenceFactory;
    private final Reference<JarCache> cache;
    private final JarAccessUtils jarAccessUtils;

    public JarAccessFactory(ReferenceFactory referenceFactory, int n, ZipTools zipTools, MessageDigest messageDigest) {
        this.referenceFactory = referenceFactory;
        this.jarAccessUtils = new JarAccessUtils(zipTools, messageDigest);
        this.cache = referenceFactory.createNewReference(new JarCache(n));
    }

    private JarAccess create(JarFile jarFile, JarSource jarSource, JarAccess.InitiatedBy initiatedBy) {
        String string;
        URL uRL = jarSource.getUrl();
        String string2 = uRL.toString();
        String string3 = string = jarFile != null ? jarFile.getName() : null;
        if (Tweaks.DEBUG_JARLOAD) {
            this.logger.trace("create jarAccess from: (jar=%s, url=%s, path=%s, source=%s, initiatedBy=%s)", new Object[]{Utils.toStringWithIdentityHash(jarFile), uRL, string, string2, initiatedBy});
        }
        if (this.cache.get().isPathKnown(string) || this.cache.get().isURLKnown(uRL) || this.cache.get().isSourceKnown(string2)) {
            this.logger.trace("Skip already known JAR reporting: %s (path: %s, source: %s, jar: %s)", uRL, string, string2, Utils.toStringWithIdentityHash(jarFile));
            return null;
        }
        try {
            if (!ZipTools.isJDKNative(jarFile)) {
                string = URLHelper.extractContainerPathFromURL(uRL.toString()).replaceAll("!/.*$", "");
                uRL = new URL("jar:file:" + string + "!/");
                string2 = uRL.toString();
                jarFile = new JarFile(string, false);
                JarSource jarSource2 = new JarSource.Builder().fromUrl(uRL).build();
                if (jarSource2 != null) {
                    return this.create(jarFile, jarSource2, initiatedBy);
                }
                throw new RuntimeException("Failed creating jarAccess jar=" + Utils.toStringWithIdentityHash(jarFile) + ", url=" + uRL + ", source=" + string2 + ", path=" + string);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed creating jarAccess jar=" + Utils.toStringWithIdentityHash(jarFile) + ", url=" + uRL + ", source=" + string2 + ", path=" + string, exception);
        }
        if (Tweaks.DEBUG_JARLOAD) {
            this.logger.trace("before creating jarAccess: %s, %s, %s, %s, %s", new Object[]{this, Utils.toStringWithIdentityHash(jarFile), uRL, string, string2, initiatedBy});
        }
        JarAccess jarAccess = new JarAccess(this.referenceFactory, this.jarAccessUtils, jarFile, jarSource, string, initiatedBy);
        this.cache.get().put(jarAccess);
        if (Tweaks.DEBUG_JARLOAD) {
            this.logger.trace("created jarAccess: %s", jarAccess);
        }
        return jarAccess;
    }

    private JarAccess createSafe(JarFile jarFile, JarSource jarSource, JarAccess.InitiatedBy initiatedBy) {
        if (jarSource == null) {
            throw new RuntimeException("Source can not be null");
        }
        if (initiatedBy == null) {
            throw new RuntimeException("InitiatedBy can not be null");
        }
        URL uRL = jarSource.getUrl();
        if (uRL == null) {
            throw new RuntimeException("URL in JarSource can not be null");
        }
        jarFile = jarFile != null ? jarFile : this.getJar(uRL);
        return this.create(jarFile, jarSource, initiatedBy);
    }

    private JarFile getJar(URL uRL) {
        try {
            return ((JarURLConnection)uRL.openConnection()).getJarFile();
        }
        catch (Exception exception) {
            this.logger.debug("Failed to get jar file by url='%s', e='%s'", uRL, exception);
            return null;
        }
    }

    public synchronized JarAccess create(JarSource jarSource, JarFile jarFile) {
        return this.createSafe(jarFile, jarSource, ZipTools.isJDKNative(jarFile) ? JarAccess.InitiatedBy.JDK_NATIVE_LOADING : JarAccess.InitiatedBy.OTHER);
    }

    public synchronized JarAccess create(JarSource jarSource, JarAccess.InitiatedBy initiatedBy) {
        return this.createSafe(null, jarSource, initiatedBy);
    }

    private static Logger logger() {
        return Logger.getLogger(JarAccessFactory.class);
    }
}

