/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.jars;

import com.azul.crs.client.Tweaks;
import com.azul.crs.client.jars.SourceCache;
import com.azul.crs.runtime.utils.KnownAzulRuntimeContainers;
import com.azul.crs.runtime.utils.URLHelper;
import com.azul.crs.util.logging.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;

public class JarURLFactory {
    private static final Logger logger = Logger.getLogger(JarURLFactory.class);
    private static final Set<String> knownVmJars = JarURLFactory.initKnownVmJars();

    public JarURLFactory() {
        if (Tweaks.DEBUG_JARLOAD) {
            for (String string : knownVmJars) {
                logger.trace("known jar = %s", string);
            }
        }
    }

    private static Set<String> initKnownVmJars() {
        String string = System.getProperty("java.home");
        String string2 = System.getProperty("java.specification.version");
        return KnownAzulRuntimeContainers.get(string, string2);
    }

    public static boolean isVmKnownJar(String string) {
        return knownVmJars.contains(string);
    }

    public static URL createURL(String string, SourceCache sourceCache) {
        if (string == null) {
            return null;
        }
        String string2 = URLHelper.toNormalizedJarURL(string);
        if (sourceCache != null && !sourceCache.add(string2)) {
            return null;
        }
        String string3 = URLHelper.extractContainerPathFromURL(string2);
        if (JarURLFactory.isVmKnownJar(string3)) {
            logger.trace("Skip VM JAR reporting: source(%s) containerId(%s)", string, string3);
            return null;
        }
        if (new File(string3).exists()) {
            return JarURLFactory.toURL("jar:file:" + string3 + "!/");
        }
        return JarURLFactory.toURL(string2);
    }

    static URL createURL(String string) {
        return JarURLFactory.createURL(string, null);
    }

    private static URL toURL(String string) {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            logger.debug("Failed to convert source(%s) to url (stacktrace: %s)", string, new RuntimeException("debug stacktrace"));
            return null;
        }
    }
}

