/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.jars.tracker;

import com.azul.crs.client.jars.tracker.JarDetailsEnum;
import com.azul.crs.client.jars.tracker.JarProcessingStatusEnum;
import com.azul.crs.client.jars.tracker.JarTrackerEnum;
import com.azul.crs.client.jars.tracker.JarUnfinishedReasonEnum;
import com.azul.crs.util.logging.Logger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class JarTracker {
    private final Logger logger = Logger.getLogger(JarTracker.class);
    private JarFile jar;
    private URL url;
    private String path;
    private JarTrackerEnum state = JarTrackerEnum.NONE;
    private JarDetailsEnum jarDetails = JarDetailsEnum.NO_INFO;
    private JarUnfinishedReasonEnum unfinishedReason = JarUnfinishedReasonEnum.WAITING_FOR_EXECUTOR;
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private JarProcessingStatusEnum processingStatus = JarProcessingStatusEnum.IN_PROGRESS;

    public JarTracker(JarFile jarFile, URL uRL, String string) {
        this.jar = jarFile;
        this.url = uRL;
        this.path = string;
    }

    public void info() {
        this.logger.info(this.getMessage(), new Object[0]);
    }

    public void trace(JarTrackerEnum jarTrackerEnum) {
        this.state = jarTrackerEnum;
        this.logger.trace(this.getMessage(), new Object[0]);
    }

    public void unfinished(JarUnfinishedReasonEnum jarUnfinishedReasonEnum) {
        this.unfinishedReason = jarUnfinishedReasonEnum;
        this.processingStatus = JarProcessingStatusEnum.IN_PROGRESS;
        this.logger.trace(this.getMessage(), new Object[0]);
    }

    private String getJarName() {
        return this.jar != null ? this.jar.getName() : null;
    }

    private String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("JarTracker [name=").append(this.getJarName()).append(", url=").append(this.url).append(", path=").append(this.path).append("] ").append((Object)this.processingStatus).append(" ");
        if (this.processingStatus == JarProcessingStatusEnum.IN_PROGRESS) {
            stringBuilder.append("[").append((Object)this.unfinishedReason).append("] ");
        }
        stringBuilder.append("status=").append((Object)this.state).append(", details=").append((Object)this.jarDetails);
        if (this.exceptions.size() > 0) {
            stringBuilder.append(",\n" + this.exceptions.stream().map(exception -> Objects.toString(exception)).collect(Collectors.joining("\n\t", "exceptions: \n\t", "")));
        }
        return stringBuilder.toString();
    }

    public void traceDetails(JarDetailsEnum jarDetailsEnum) {
        this.jarDetails = jarDetailsEnum;
    }

    public void traceError(Exception exception) {
        this.exceptions.add(exception);
    }

    public void finish() {
        this.processingStatus = this.exceptions.isEmpty() ? JarProcessingStatusEnum.FINISHED : JarProcessingStatusEnum.FINISHED_WITH_ERRORS;
        this.logger.trace(this.getMessage(), new Object[0]);
    }

    public void cancel(Exception exception) {
        if (exception != null) {
            this.exceptions.add(exception);
        }
        this.processingStatus = JarProcessingStatusEnum.CANCELLED;
        this.logger.trace(this.getMessage(), new Object[0]);
    }

    public boolean hasStatus(JarTrackerEnum jarTrackerEnum) {
        return this.state.equals((Object)jarTrackerEnum);
    }

    public boolean statusIn(JarTrackerEnum ... jarTrackerEnumArray) {
        return Arrays.stream(jarTrackerEnumArray).anyMatch(jarTrackerEnum -> this.hasStatus((JarTrackerEnum)((Object)jarTrackerEnum)));
    }

    public String toString() {
        return this.getMessage();
    }

    public boolean assertStatusIn(String string, JarTrackerEnum ... jarTrackerEnumArray) {
        if (!this.statusIn(jarTrackerEnumArray)) {
            this.logger.warning("Unexpected state of %s %s: expected actual=%s, to be in [%s]", new Object[]{this, string, this.state, Arrays.stream(jarTrackerEnumArray).map(jarTrackerEnum -> Objects.toString(jarTrackerEnum)).collect(Collectors.joining(","))});
            return false;
        }
        return true;
    }
}

