/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.safeguards;

import com.azul.crs.client.safeguards.HardReference;
import com.azul.crs.client.safeguards.Reference;
import com.azul.crs.client.safeguards.ReferenceFactory;
import com.azul.crs.client.safeguards.ThrowingRunnable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class HardReferenceFactory
implements ReferenceFactory {
    static final ThreadGroup threadGroup = new ThreadGroup("CRS-agent");
    private final AtomicInteger counter = new AtomicInteger();

    @Override
    public String stats() {
        throw new RuntimeException("should not reach here");
    }

    @Override
    public void onShutdown() {
    }

    @Override
    public <T> Reference<T> createNewReference(T t) {
        return new HardReference<T>(t);
    }

    @Override
    public <T> BlockingQueue<T> createNewBlockingQueue(int n) {
        return new LinkedBlockingDeque(n);
    }

    @Override
    public <T> BlockingQueue<T> createNewBlockingQueue() {
        return new LinkedBlockingDeque();
    }

    @Override
    public ThreadFactory createThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return new Thread(threadGroup, runnable, String.format("CRS-ES-%3d", HardReferenceFactory.this.counter.incrementAndGet()));
            }
        };
    }

    @Override
    public void oomSafeRun(Runnable runnable) {
        runnable.run();
    }

    @Override
    public <E extends Throwable> void oomSafeRunThrowing(ThrowingRunnable<E> throwingRunnable) throws E {
        throwingRunnable.run();
    }

    @Override
    public void notifyWithException(Throwable throwable) {
    }

    @Override
    public void ensureIsAlive() {
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return threadGroup;
    }
}

