/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.safeguards;

import com.azul.crs.client.safeguards.InsufficientMemoryException;
import com.azul.crs.client.safeguards.Reference;
import com.azul.crs.client.safeguards.SafeReferenceFactory;
import com.azul.crs.client.safeguards.ThrowingRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SafeBlockingQueue<T>
implements BlockingQueue<T> {
    private final SafeReferenceFactory referenceFactory;
    private final Reference<Map<T, Reference<T>>> weakMap;
    private final Reference<BlockingQueue<Reference<T>>> delegate;
    private AtomicBoolean oomThrown = new AtomicBoolean();

    public SafeBlockingQueue(SafeReferenceFactory safeReferenceFactory) {
        this.referenceFactory = safeReferenceFactory;
        this.delegate = safeReferenceFactory.createNewReference(new LinkedBlockingDeque());
        this.weakMap = safeReferenceFactory.createNewReference(Collections.synchronizedMap(new WeakHashMap()));
    }

    public SafeBlockingQueue(SafeReferenceFactory safeReferenceFactory, int n) {
        this.referenceFactory = safeReferenceFactory;
        this.delegate = safeReferenceFactory.createNewReference(new LinkedBlockingDeque(n));
        this.weakMap = safeReferenceFactory.createNewReference(Collections.synchronizedMap(new WeakHashMap()));
    }

    private <U, E extends Throwable> U throwOomOnce(ThrowingSupplier<U, E> throwingSupplier, U u) throws E {
        try {
            return throwingSupplier.supply();
        }
        catch (InsufficientMemoryException insufficientMemoryException) {
            if (this.oomThrown.compareAndSet(false, true)) {
                throw insufficientMemoryException;
            }
            return u;
        }
    }

    private <E extends Throwable> void throwOomAlways(ThrowingRunnable<E> throwingRunnable) throws E {
        try {
            throwingRunnable.run();
        }
        catch (InsufficientMemoryException insufficientMemoryException) {
            this.oomThrown.set(true);
            throw insufficientMemoryException;
        }
    }

    private <U, E extends Throwable> U throwOomAlways(ThrowingSupplier<U, E> throwingSupplier) throws E {
        try {
            return throwingSupplier.supply();
        }
        catch (InsufficientMemoryException insufficientMemoryException) {
            this.oomThrown.set(true);
            throw insufficientMemoryException;
        }
    }

    private Reference<T> newRef(T t) {
        Reference<T> reference = this.referenceFactory.createNewReference(t);
        this.weakMap.get().put(t, reference);
        return reference;
    }

    private T releaseRef(T t) {
        if (t != null) {
            this.weakMap.get().remove(t);
        }
        return t;
    }

    private Collection<?> getAllRefs(Collection<?> collection) {
        return this.throwOomAlways(() -> collection.stream().map(object -> this.weakMap.get().get(object)).collect(Collectors.toList()));
    }

    @Override
    public boolean add(T t) {
        return this.throwOomAlways(() -> this.delegate.get().add(this.newRef(t)));
    }

    @Override
    public boolean offer(T t) {
        return this.throwOomAlways(() -> this.delegate.get().offer(this.newRef(t)));
    }

    @Override
    public T remove() {
        return (T)this.throwOomAlways(() -> ((Reference)this.delegate.get().remove()).get());
    }

    @Override
    public T poll() {
        return (T)this.throwOomAlways(() -> this.releaseRef(((Reference)this.delegate.get().poll()).get()));
    }

    @Override
    public T element() {
        return (T)this.throwOomAlways(() -> ((Reference)this.delegate.get().element()).get());
    }

    @Override
    public T peek() {
        return (T)this.throwOomAlways(() -> this.releaseRef(((Reference)this.delegate.get().peek()).get()));
    }

    @Override
    public void put(T t) throws InterruptedException {
        this.throwOomAlways(() -> this.delegate.get().put(this.newRef(t)));
    }

    @Override
    public boolean offer(T t, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.throwOomAlways(() -> this.delegate.get().offer(this.newRef(t), l, timeUnit));
    }

    @Override
    public T take() throws InterruptedException {
        return this.throwOomOnce(() -> this.releaseRef(this.delegate.get().take().get()), null);
    }

    @Override
    public T poll(long l, TimeUnit timeUnit) throws InterruptedException {
        Reference reference = this.throwOomOnce(() -> this.delegate.get().poll(l, timeUnit), null);
        return reference == null ? null : this.throwOomOnce(() -> this.releaseRef(reference.get()), null);
    }

    @Override
    public int remainingCapacity() {
        return this.throwOomAlways(() -> this.delegate.get().remainingCapacity());
    }

    @Override
    public boolean remove(Object object) {
        Reference reference = this.throwOomAlways(() -> this.weakMap.get().get(object));
        boolean bl = this.throwOomAlways(() -> this.delegate.get().remove(reference));
        if (bl) {
            this.throwOomAlways(() -> this.releaseRef(object));
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.throwOomAlways(() -> this.delegate.get().containsAll(this.getAllRefs(collection)));
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean bl = true;
        for (T t : collection) {
            bl &= this.add(t);
        }
        return bl;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.throwOomAlways(() -> this.delegate.get().removeAll(this.getAllRefs(collection)));
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        return this.throwOomAlways(() -> this.delegate.get().removeIf((? super E reference) -> predicate.test((Object)reference.get())));
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.throwOomAlways(() -> this.delegate.get().retainAll(this.getAllRefs(collection)));
    }

    @Override
    public void clear() {
        this.throwOomAlways(() -> this.delegate.get().clear());
    }

    @Override
    public Spliterator<T> spliterator() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Stream<T> stream() {
        return this.throwOomAlways(() -> this.delegate.get().stream().map(reference -> reference.get()));
    }

    @Override
    public Stream<T> parallelStream() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public int size() {
        return this.throwOomOnce(() -> this.delegate.get().size(), 0);
    }

    @Override
    public boolean isEmpty() {
        return this.throwOomOnce(() -> this.delegate.get().isEmpty(), true);
    }

    @Override
    public boolean contains(Object object) {
        return this.throwOomAlways(() -> this.delegate.get().contains(this.weakMap.get().get(object)));
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<Reference<T>> delegateIteragor;
            {
                this.delegateIteragor = (Iterator)SafeBlockingQueue.this.throwOomAlways(() -> ((BlockingQueue)SafeBlockingQueue.this.delegate.get()).iterator());
            }

            @Override
            public boolean hasNext() {
                return this.delegateIteragor.hasNext();
            }

            @Override
            public T next() {
                return SafeBlockingQueue.this.throwOomAlways(() -> this.delegateIteragor.next().get());
            }
        };
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        this.throwOomAlways(() -> this.delegate.get().forEach(reference -> consumer.accept((Object)reference.get())));
    }

    @Override
    public Object[] toArray() {
        return this.throwOomAlways(() -> this.delegate.get().stream().map(reference -> reference.get()).toArray());
    }

    @Override
    public <T1> T1[] toArray(T1[] T1Array) {
        return this.throwOomAlways(() -> this.delegate.get().stream().map(reference -> reference.get()).toArray());
    }

    @Override
    public int drainTo(Collection<? super T> collection) {
        ArrayList arrayList = new ArrayList();
        int n = this.throwOomAlways(() -> this.delegate.get().drainTo(arrayList));
        collection.addAll(this.throwOomAlways(() -> arrayList.stream().map(reference -> reference.get()).collect(Collectors.toList())));
        return n;
    }

    @Override
    public int drainTo(Collection<? super T> collection, int n) {
        ArrayList arrayList = new ArrayList();
        int n2 = this.throwOomAlways(() -> this.delegate.get().drainTo(arrayList, n));
        collection.addAll(this.throwOomAlways(() -> arrayList.stream().map(reference -> reference.get()).collect(Collectors.toList())));
        return n2;
    }

    private static interface ThrowingSupplier<U, E extends Throwable> {
        public U supply() throws E;
    }
}

