/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.safeguards;

import com.azul.crs.client.safeguards.InsufficientMemoryException;
import com.azul.crs.client.safeguards.Reference;
import com.azul.crs.client.safeguards.SafeReferenceFactory;
import java.lang.ref.SoftReference;

public class SafeReference<T>
extends Reference<T> {
    private final SoftReference<T> objectReference;
    private final SafeReferenceFactory referenceFactory;

    SafeReference(T t, SafeReferenceFactory safeReferenceFactory) {
        super(t);
        this.objectReference = new SoftReference<T>(t);
        this.referenceFactory = safeReferenceFactory;
    }

    @Override
    T getInner() {
        return this.objectReference.get();
    }

    @Override
    public T get() {
        try {
            this.referenceFactory.ensureIsAlive();
        }
        catch (InsufficientMemoryException insufficientMemoryException) {
            SafeReferenceFactory.onTheFlyClearedReferences.incrementAndGet();
            this.release();
            SafeReferenceFactory.getOnReleasedObject.incrementAndGet();
            this.referenceFactory.onReferenceNotAliveCallback(this);
            throw insufficientMemoryException;
        }
        T t = this.getInner();
        if (t == null) {
            SafeReferenceFactory.getOnReleasedObject.incrementAndGet();
            this.referenceFactory.onReferenceNotAliveCallback(this);
            throw new InsufficientMemoryException(this.referenceFactory, "Object inaccessible", t, this.klass);
        }
        return t;
    }

    @Override
    void release() {
        this.objectReference.clear();
    }

    @Override
    boolean isReleased() {
        return this.getInner() != null;
    }
}

