/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.safeguards;

import com.azul.crs.client.Tweaks;
import com.azul.crs.client.safeguards.InsufficientMemoryException;
import com.azul.crs.client.safeguards.NullReference;
import com.azul.crs.client.safeguards.Reference;
import com.azul.crs.client.safeguards.ReferenceFactory;
import com.azul.crs.client.safeguards.SafeBlockingQueue;
import com.azul.crs.client.safeguards.SafeProxySet;
import com.azul.crs.client.safeguards.SafeReference;
import com.azul.crs.client.safeguards.SafeThreadFactory;
import com.azul.crs.client.safeguards.ThrowingRunnable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class SafeReferenceFactory
implements ReferenceFactory {
    private Set<Reference<?>> allAliveRefs = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private Set<Object> allAliveChildrenObjects = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final boolean DEBUG;
    private final Runnable callback;
    private final AtomicBoolean isAlive = new AtomicBoolean(true);
    private final int limitRefDump = 999999;
    private final ThreadGroup threadGroup;
    static AtomicInteger preemptivelyThrownInsufficientMemory = new AtomicInteger();
    static AtomicInteger getOnReleasedObject = new AtomicInteger();
    static AtomicInteger onTheFlyClearedReferences = new AtomicInteger();
    static AtomicInteger amountOfRegisteredOOMErrors = new AtomicInteger();
    static String onStartMemStats = SafeReferenceFactory.memStats();
    static String onFirstHitMemStats = SafeReferenceFactory.memStats();

    public SafeReferenceFactory(boolean bl, Runnable runnable) {
        this.callback = runnable;
        this.DEBUG = Tweaks.DEBUG_SAFEGUARDS && bl;
        this.threadGroup = new ThreadGroup("CRS-agent"){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                SafeReferenceFactory.this.notifyWithException(throwable);
            }
        };
    }

    private static String memStats() {
        return String.format("maxMemory=%d, freeMemory=%d, totalMemory=%d", Runtime.getRuntime().maxMemory(), Runtime.getRuntime().freeMemory(), Runtime.getRuntime().totalMemory());
    }

    @Override
    public String stats() {
        return String.format("onStartMemStats = { %s }, onFirstHitMemStats = { %s }, preemptivelyThrownInsufficientMemory=%d, getOnReleasedObject=%d, onTheFlyClearedReferences=%d, amountOfRegisteredOOMErrors=%d", onStartMemStats, onFirstHitMemStats, preemptivelyThrownInsufficientMemory.get(), getOnReleasedObject.get(), onTheFlyClearedReferences.get(), amountOfRegisteredOOMErrors.get());
    }

    @Override
    public void onShutdown() {
        if (this.DEBUG) {
            List list = new ArrayList(this.allAliveRefs).stream().filter(reference -> !reference.isReleased()).collect(Collectors.toList());
            boolean bl = this.isAlive.get();
            System.err.println(String.format("[CRS.memory][debug] agent terminating %s. Alive objects: non-null refs=%d, alive children objects=%d", bl ? "correctly" : "because of OOM", list.size(), this.allAliveChildrenObjects.size()));
            int n = 0;
            if (!bl && this.allAliveChildrenObjects.size() > 0) {
                for (Object object : new ArrayList<Object>(this.allAliveChildrenObjects)) {
                    String string = object == null ? null : String.format("%s@%x", object.getClass(), Objects.hashCode(object));
                    System.err.println("[CRS.memory][debug]: Alive child object: " + string);
                    if (n++ <= 999999) continue;
                    System.err.println("...");
                    break;
                }
            }
            n = 0;
            if (!bl && list.size() > 0) {
                for (Object object : list) {
                    System.err.println("[CRS.memory][debug]: Alive ref: " + object);
                    if (n++ <= 999999) continue;
                    System.err.println("...");
                    break;
                }
            }
            System.err.println(String.format("Final stats: %s", this.stats()));
        }
    }

    @Override
    public <T> Reference<T> createNewReference(T t) {
        this.ensureIsAlive();
        this.trackChildren(t);
        if (t == null) {
            return new NullReference<T>(t);
        }
        SafeReference<T> safeReference = null;
        safeReference = new SafeReference<T>(t, this);
        if (this.DEBUG) {
            this.allAliveRefs.add(safeReference);
        }
        return safeReference;
    }

    @Override
    public <T> BlockingQueue<T> createNewBlockingQueue(int n) {
        this.ensureIsAlive();
        return new SafeBlockingQueue(this, n);
    }

    @Override
    public <T> BlockingQueue<T> createNewBlockingQueue() {
        this.ensureIsAlive();
        return new SafeBlockingQueue(this);
    }

    private <T> Set<T> createSafeProxySet(Set<T> set) {
        this.ensureIsAlive();
        return new SafeProxySet<T>(this, set);
    }

    private <K, V> SafeProxySet<K> createSafeProxySetFromMap(Map<K, Boolean> map) {
        this.ensureIsAlive();
        return new SafeProxySet<K>(this, Collections.newSetFromMap(map));
    }

    @Override
    public ThreadFactory createThreadFactory() {
        return new SafeThreadFactory(this);
    }

    @Override
    public void oomSafeRun(Runnable runnable) {
        this.ensureIsAlive();
        try {
            runnable.run();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.isAlive.set(false);
            this.callback.run();
            throw new InsufficientMemoryException(this, "Memory allocation caused OOM: ", outOfMemoryError);
        }
    }

    @Override
    public <E extends Throwable> void oomSafeRunThrowing(ThrowingRunnable<E> throwingRunnable) throws E {
        this.ensureIsAlive();
        try {
            throwingRunnable.run();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.isAlive.set(false);
            this.callback.run();
            throw new InsufficientMemoryException(this, "Memory allocation caused OOM: ", outOfMemoryError);
        }
    }

    @Override
    public void notifyWithException(Throwable throwable) {
        if (throwable != null && OutOfMemoryError.class.isAssignableFrom(throwable.getClass())) {
            amountOfRegisteredOOMErrors.incrementAndGet();
            this.isAlive.set(false);
        }
    }

    private Set<Object> children(Object object) {
        if (!this.DEBUG) {
            throw new RuntimeException("should not reach here");
        }
        if (object == null) {
            return Collections.emptySet();
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (Field field : object.getClass().getFields()) {
            try {
                field.setAccessible(true);
                hashSet.add(field.get(object));
            }
            catch (Exception exception) {
                System.err.println("Failed to access field: " + field + ", of the object: " + object);
                exception.printStackTrace();
            }
        }
        return hashSet;
    }

    private void trackChildren(Object object) {
        if (this.DEBUG) {
            this.allAliveChildrenObjects.add(object);
            this.allAliveChildrenObjects.addAll(this.children(object));
        }
    }

    void release(Reference<?> reference) {
        if (this.DEBUG) {
            this.allAliveRefs.remove(reference);
        }
    }

    @Override
    public void ensureIsAlive() {
        if (!this.isAlive.get()) {
            preemptivelyThrownInsufficientMemory.incrementAndGet();
            throw new InsufficientMemoryException(this, "Memory allocation previously caused OOM");
        }
    }

    void onReferenceNotAliveCallback(Reference<?> reference) {
        onFirstHitMemStats = SafeReferenceFactory.memStats();
        this.isAlive.set(false);
        this.release(reference);
        this.callback.run();
    }

    public <T extends Throwable> void rethrowIfFirst(T t) throws T {
        if (this.isAlive.compareAndSet(false, true)) {
            this.callback.run();
            throw t;
        }
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }
}

