/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.InterfaceConnectionManager;
import com.azul.crs.client.Tweaks;
import com.azul.crs.client.Utils;
import com.azul.crs.client.featureflags.FeatureFlagsConfiguration;
import com.azul.crs.client.models.VMEvent;
import com.azul.crs.client.safeguards.ReferenceFactory;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.QueueService;
import com.azul.crs.util.logging.Logger;
import com.azul.crs.util.logging.LoggingHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class EventService
implements ClientService {
    private final Client client;
    private final QueueService<VMEvent> queue;
    private volatile boolean fullyStarted = false;
    private VMEvent vmStart = null;
    private List<VMEvent> eventsToBeSentSynchronously = new ArrayList<VMEvent>();

    private EventService(Client client, ReferenceFactory referenceFactory) {
        this.client = client;
        this.queue = new QueueService.Builder().maxQueueSize(Tweaks.MAX_QUEUE_SIZE).maxBatchSize(Tweaks.BATCH_SIZE).maxWorkers(Tweaks.MAX_WORKERS).postBatch(this::postWithRetries).filter(this::filter).cancelBatch(this::discard).name("EVENT").referenceFactory(referenceFactory).build();
    }

    private boolean filter(VMEvent vMEvent) {
        if (FeatureFlagsConfiguration.isEnabled(vMEvent.getEventType())) {
            return true;
        }
        vMEvent.getEventType().subtractInFlightEventsCount(1);
        vMEvent.callOnError();
        return false;
    }

    public static EventService getInstance(Client client, ReferenceFactory referenceFactory) {
        return new EventService(client, referenceFactory);
    }

    public void add(VMEvent vMEvent) {
        VMEvent.Type type = vMEvent.getEventType();
        int n = type.incrementInFlightEventsCount();
        boolean bl = this.queue.add(vMEvent);
        if (!bl) {
            n = type.subtractInFlightEventsCount(1);
            vMEvent.callOnError();
        }
        if (Tweaks.DEBUG_EVENT_SERVICE) {
            this.logger().trace("Queue %s: Event of type %s %s added. [InFlightEventsCount=%d]", new Object[]{this.queue.serviceName(), type, bl ? "was" : "was not", n});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSynchronously(VMEvent vMEvent) {
        if (this.vmStart == null) {
            throw new RuntimeException("Too early... vmCreate should be scheduled!");
        }
        if (this.fullyStarted) {
            this.queue.skipOverQueue(vMEvent);
        } else {
            EventService eventService = this;
            synchronized (eventService) {
                if (this.fullyStarted) {
                    this.queue.skipOverQueue(vMEvent);
                } else {
                    this.eventsToBeSentSynchronously.add(vMEvent);
                }
            }
        }
    }

    public void addVmStart(VMEvent vMEvent) {
        VMEvent.Type type = vMEvent.getEventType();
        if (type != VMEvent.Type.VM_CREATE) {
            throw new RuntimeException("addVmStart - incorrect event type: " + (Object)((Object)vMEvent.getEventType()));
        }
        if (this.fullyStarted) {
            throw new RuntimeException("addVmStart - must be called before the queue is started");
        }
        if (this.vmStart != null) {
            throw new RuntimeException("addVmStart - can not be called twice");
        }
        type.incrementInFlightEventsCount();
        this.vmStart = vMEvent;
    }

    public void addAll(Collection<VMEvent> collection) {
        collection.forEach(this::add);
    }

    @Override
    public String serviceName() {
        return "client.service.Events";
    }

    @Override
    public void start() {
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.queue.stop(deadline);
    }

    @Override
    public void terminate() {
        this.cancel();
    }

    public void cancel() {
        this.queue.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionEstablished() {
        if (this.vmStart != null) {
            this.queue.skipOverQueue(this.vmStart);
        }
        this.sendAllSynchronousEvents();
        this.queue.start();
        EventService eventService = this;
        synchronized (eventService) {
            this.fullyStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllSynchronousEvents() {
        if (this.vmStart == null) {
            throw new RuntimeException("Too early... vmCreate should be scheduled!");
        }
        EventService eventService = this;
        synchronized (eventService) {
            for (VMEvent vMEvent : this.eventsToBeSentSynchronously) {
                this.queue.skipOverQueue(vMEvent);
            }
            this.eventsToBeSentSynchronously.clear();
        }
    }

    private void callSafe(VMEvent vMEvent, boolean bl) {
        try {
            if (Tweaks.DEBUG_EVENT_SERVICE) {
                System.out.println(">>> call on succeed=" + bl + ", e=" + vMEvent);
            }
            if (bl) {
                vMEvent.callOnSuccess();
            } else {
                vMEvent.callOnError();
            }
        }
        catch (Throwable throwable) {
            LoggingHelper.logUnhandledException(this.logger(), Logger.Level.ERROR, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postWithRetries(String string, Collection<VMEvent> collection) {
        this.logger().trace("event worker tries to post batch of %,d VM events", collection.size());
        boolean bl = false;
        try {
            InterfaceConnectionManager interfaceConnectionManager = this.client.getConnectionManager();
            bl = interfaceConnectionManager.requestWithRetries(() -> interfaceConnectionManager.sendVMEventBatch(collection), "postEventBatch", Tweaks.EVENT_MAX_RETRIES, Tweaks.EVENT_RETRY_SLEEP);
        }
        finally {
            collection.stream().collect(Collectors.groupingBy(vMEvent -> vMEvent.getEventType(), Collectors.counting())).forEach((type, l) -> type.subtractInFlightEventsCount(l.intValue()));
            boolean bl2 = bl;
            collection.forEach(vMEvent -> this.callSafe((VMEvent)vMEvent, bl2));
        }
    }

    private void discard(String string, Collection<VMEvent> collection) {
        collection.forEach(vMEvent -> this.callSafe((VMEvent)vMEvent, false));
    }
}

