/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Tweaks;
import com.azul.crs.client.Utils;
import com.azul.crs.client.jars.JarAccess;
import com.azul.crs.client.jars.VmJarInfoRequestSupport;
import com.azul.crs.client.jars.tracker.JarUnfinishedReasonEnum;
import com.azul.crs.client.service.MonitorService;
import com.azul.crs.client.service.ServerRequestsService;
import com.azul.crs.util.logging.Logger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;

public class JarDetailsRequestMonitor
extends MonitorService {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final AtomicLong taskInProgressCounter = new AtomicLong();
    private boolean fullQueueErrorSent = false;
    private final Map<String, DetailsRequestToExpect> detailsRequestToExpectMap = new ConcurrentHashMap<String, DetailsRequestToExpect>();

    @Override
    public void start() {
    }

    public boolean expectingRequests() {
        return Tweaks.WAIT_ALL_JAR_REQUESTS && this.taskInProgressCounter.get() > 0L;
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.logger.trace("stop (ntd) finished, deadline=%s; unfinished details requests: %d; task in progress counter: %d", deadline, this.detailsRequestToExpectMap.size(), this.taskInProgressCounter.get());
        for (Map.Entry<String, DetailsRequestToExpect> entry : this.detailsRequestToExpectMap.entrySet()) {
            entry.getValue().jarAccess.getTracker().unfinished(JarUnfinishedReasonEnum.WAITING_FOR_DETAILS);
        }
    }

    @Override
    public void terminate() {
        this.cancel();
    }

    @Override
    public void cancel() {
    }

    public JarDetailsRequestMonitor() {
        ServerRequestsService.addListener(VmJarInfoRequestSupport.VmJarInfoRequest.class, this::processVmJarInfoRequest);
    }

    private String getKey(VmJarInfoRequestSupport.VmJarInfoRequest vmJarInfoRequest) {
        return vmJarInfoRequest.getCDHash() + ":" + vmJarInfoRequest.getPath();
    }

    private String getKey(JarAccess jarAccess) {
        return jarAccess.getHash() + ":" + jarAccess.getJarName();
    }

    private void processVmJarInfoRequest(VmJarInfoRequestSupport.VmJarInfoRequest vmJarInfoRequest) {
        this.logger.trace("requested processVmJarInfoRequest: " + vmJarInfoRequest, new Object[0]);
        DetailsRequestToExpect detailsRequestToExpect = this.detailsRequestToExpectMap.remove(this.getKey(vmJarInfoRequest));
        if (detailsRequestToExpect == null) {
            this.logger.warning("Failed to process vmJarInfoRequest=(" + vmJarInfoRequest + "), there is no corresponding request in queue", new Object[0]);
            return;
        }
        detailsRequestToExpect.jarAccess.setInitiatedBy(JarAccess.InitiatedBy.SERVER_REQUEST);
        this.logger.trace("task processVmJarInfoRequest: " + vmJarInfoRequest, new Object[0]);
        try {
            detailsRequestToExpect.consumer.accept(vmJarInfoRequest.getDetailsLevel(), null);
        }
        finally {
            this.taskInProgressCounter.decrementAndGet();
        }
    }

    public void cancel(JarAccess jarAccess) {
        this.logger.trace("canceling waiting for detail level request for %s", jarAccess);
        DetailsRequestToExpect detailsRequestToExpect = this.detailsRequestToExpectMap.remove(jarAccess);
        if (null != detailsRequestToExpect) {
            detailsRequestToExpect.consumer.accept(null, new RuntimeException("canceled"));
            this.taskInProgressCounter.decrementAndGet();
        }
    }

    public void waitFor(ExecutorService executorService, JarAccess jarAccess, BiConsumer<VmJarInfoRequestSupport.VmJarInfoRequest.DetailsLevel, Exception> biConsumer) {
        this.logger.trace("schedule waiting for detail level request for %s", jarAccess);
        if (this.detailsRequestToExpectMap.size() > Tweaks.jarLoadMonitorTaskQueueSize) {
            if (!this.fullQueueErrorSent) {
                this.logger.error("JarDetailsRequestMonitor queue limit has been reached (jarLoadMonitorTaskQueueSize == %d)", Tweaks.jarLoadMonitorTaskQueueSize);
                this.fullQueueErrorSent = true;
            }
            throw new RuntimeException("limit reached: detailsRequestToExpectMap.size[" + this.detailsRequestToExpectMap.size() + "] > Tweaks.jarLoadMonitorTaskQueueSize[" + Tweaks.jarLoadMonitorTaskQueueSize + "]");
        }
        this.taskInProgressCounter.incrementAndGet();
        this.detailsRequestToExpectMap.put(this.getKey(jarAccess), new DetailsRequestToExpect(executorService, jarAccess, biConsumer));
    }

    private static class DetailsRequestToExpect {
        public final JarAccess jarAccess;
        public final ExecutorService executor;
        public final BiConsumer<VmJarInfoRequestSupport.VmJarInfoRequest.DetailsLevel, Exception> consumer;

        public DetailsRequestToExpect(ExecutorService executorService, JarAccess jarAccess, BiConsumer<VmJarInfoRequestSupport.VmJarInfoRequest.DetailsLevel, Exception> biConsumer) {
            this.executor = executorService;
            this.jarAccess = jarAccess;
            this.consumer = biConsumer;
        }

        public String toString() {
            return "DetailsRequestToExpect[" + this.jarAccess + "]";
        }
    }
}

