/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Utils;
import com.azul.crs.client.safeguards.Reference;
import com.azul.crs.client.safeguards.ReferenceFactory;
import com.azul.crs.client.service.InsufficientTempfsLimitException;
import com.azul.crs.client.service.MonitorService;
import com.azul.crs.client.service.MonitorServiceException;
import com.azul.crs.runtime.utils.TempFilesFactory;
import com.azul.crs.util.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;

public class TempFilesMonitor
extends MonitorService {
    private final ExecutorService executorService;
    private final long maxLimit;
    private final long maxQueueSize;
    private final boolean waitAllJarRequests;
    private final AtomicLong currentLimit;
    private final TempFilesFactory.TempFile dummy = null;
    private final Reference<Queue<TempFileRequest>> queue;
    private final Logger logger = Logger.getLogger(this.getClass());
    private boolean fullQueueErrorSent = false;

    public TempFilesMonitor(ExecutorService executorService, ReferenceFactory referenceFactory, long l, long l2, boolean bl) {
        this.executorService = executorService;
        this.maxLimit = l;
        this.maxQueueSize = l2;
        this.waitAllJarRequests = bl;
        this.currentLimit = new AtomicLong(this.maxLimit);
        this.queue = referenceFactory.createNewReference(new ConcurrentLinkedQueue());
    }

    @Override
    public void start() {
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
        this.logger.trace("stop (ntd) finished, exiting, deadline=%s, unfinished temp file requests=%d, current limit=%d", deadline, this.queue.get().size(), this.currentLimit.get());
        for (TempFileRequest tempFileRequest : this.queue.get()) {
            tempFileRequest.completeExceptionally(new CancellationException("TempFileRequest has been cancelled because of the stop"));
        }
        this.queue.get().clear();
    }

    @Override
    public void terminate() {
        this.cancel();
    }

    @Override
    public void cancel() {
    }

    private TempFilesFactory.TempFile createTempFile(long l) throws IOException {
        long l2 = this.currentLimit.addAndGet(-l);
        if (l2 < 0L) {
            this.currentLimit.addAndGet(l);
            return null;
        }
        TempFilesFactory.TempFile tempFile2 = TempFilesFactory.createTempJarFile(tempFile -> {
            this.logger.trace("on tempfile delete: %s [%d]", Objects.toString(tempFile), l);
            PerformanceMetrics.logJarCacheDeleted(l);
            this.currentLimit.addAndGet(l);
            try {
                if (this.executorService != null) {
                    this.executorService.execute(() -> this.retryPostponed());
                } else {
                    this.retryPostponed();
                }
            }
            catch (Exception exception) {
                this.logger.error("onRelease method failed: %s", exception);
            }
        });
        if (tempFile2 != null) {
            PerformanceMetrics.logJarCacheCreated(l);
        } else {
            this.currentLimit.addAndGet(l);
        }
        return tempFile2;
    }

    public synchronized boolean expectingRequests() {
        return this.waitAllJarRequests && this.queue.get().size() > 0;
    }

    public long getCurrentLimit() {
        return this.currentLimit.get();
    }

    private synchronized void retryPostponed() {
        TempFileRequest tempFileRequest = null;
        ArrayList<TempFileRequest> arrayList = new ArrayList<TempFileRequest>();
        while (null != (tempFileRequest = this.queue.get().poll())) {
            try {
                TempFilesFactory.TempFile tempFile = this.createTempFile(tempFileRequest.size);
                if (tempFile != null) {
                    tempFileRequest.complete(tempFile);
                    continue;
                }
                arrayList.add(tempFileRequest);
            }
            catch (IOException iOException) {
                tempFileRequest.completeExceptionally(new MonitorServiceException("can not allocate tmpFile (size=" + tempFileRequest.size + "): ", iOException));
            }
        }
        this.queue.get().addAll(arrayList);
    }

    public synchronized CompletableFuture<TempFilesFactory.TempFile> allocate(long l) {
        this.logger.trace("requested temp file with size %d", l);
        if (l == 0L) {
            return CompletableFuture.completedFuture(this.dummy);
        }
        CompletableFuture<TempFilesFactory.TempFile> completableFuture = new CompletableFuture<TempFilesFactory.TempFile>();
        if (l > this.maxLimit) {
            completableFuture.completeExceptionally(new InsufficientTempfsLimitException("Requested size=" + l + " is bigger than max limit=" + this.maxLimit));
            return completableFuture;
        }
        TempFileRequest tempFileRequest = new TempFileRequest(l, completableFuture);
        try {
            TempFilesFactory.TempFile tempFile = this.createTempFile(l);
            if (tempFile != null) {
                tempFileRequest.complete(tempFile);
            } else if ((long)this.queue.get().size() >= this.maxQueueSize) {
                if (!this.fullQueueErrorSent) {
                    this.logger.error("TempFilesMonitor queue limit has been reached (%d)", this.maxQueueSize);
                    this.fullQueueErrorSent = true;
                }
                tempFileRequest.completeExceptionally(new MonitorServiceException("limit reached: TempFilesMontor.queue.size[" + this.queue.get().size() + "] > maxQueueSize[" + this.maxQueueSize + "]"));
            } else {
                PerformanceMetrics.logJarLoadPostponedDueToNoSpaceYet();
                this.queue.get().add(tempFileRequest);
            }
        }
        catch (IOException iOException) {
            tempFileRequest.completeExceptionally(new MonitorServiceException("can not allocate tmpFile (size=" + l + "): ", iOException));
        }
        return completableFuture;
    }

    private static class TempFileRequest {
        public final long size;
        public final long ms;
        private final CompletableFuture<TempFilesFactory.TempFile> future;

        public TempFileRequest(long l, CompletableFuture<TempFilesFactory.TempFile> completableFuture) {
            this.size = l;
            this.future = completableFuture;
            this.ms = Utils.currentTimeMillis();
        }

        public String toString() {
            return "TempFileRequest[" + this.size + "]";
        }

        public void complete(TempFilesFactory.TempFile tempFile) {
            PerformanceMetrics.logJarWaitingTime(Utils.currentTimeMillis() - this.ms);
            this.future.complete(tempFile);
        }

        public void completeExceptionally(Throwable throwable) {
            PerformanceMetrics.logJarWaitingTime(Utils.currentTimeMillis() - this.ms);
            this.future.completeExceptionally(throwable);
        }
    }
}

