/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.Response;
import com.azul.crs.client.Utils;
import com.azul.crs.client.models.VMArtifactChunk;
import com.azul.crs.client.safeguards.ReferenceFactory;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.client.service.DataWriter;
import com.azul.crs.client.service.QueueService;
import java.io.IOException;
import java.util.Collection;

public class UploadService
implements ClientService {
    private static final int MAX_QUEUE_SIZE = 50000;
    private static final int MAX_WORKERS = 1;
    private static final int BATCH_SIZE = 1;
    private final QueueService<Job> queue;
    private final Client client;

    public UploadService(Client client, ReferenceFactory referenceFactory) {
        this.queue = new QueueService.Builder().maxQueueSize(50000).maxBatchSize(1).maxWorkers(1).postBatch(this::send).cancelBatch(this::discard).name("UPLOAD").referenceFactory(referenceFactory).build();
        this.client = client;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        this.queue.stop(deadline);
    }

    public void cancel() {
        this.queue.cancel();
    }

    @Override
    public void terminate() {
        this.cancel();
    }

    public void connectionEstablished() {
        this.logger().trace("connection established, sending artifact data to the cloud", new Object[0]);
        this.queue.start();
    }

    public void post(VMArtifactChunk vMArtifactChunk, DataWriter dataWriter) {
        boolean bl = this.queue.add(new Job(vMArtifactChunk, dataWriter));
        if (!bl) {
            dataWriter.handleException(new RuntimeException("canceled"));
        }
    }

    public void sync() {
        this.logger().trace("syncing artifact data to the cloud", new Object[0]);
        this.queue.sync();
    }

    private void send(String string, Collection<Job> collection) {
        Job job = collection.iterator().next();
        VMArtifactChunk vMArtifactChunk = job.chunk;
        DataWriter dataWriter = job.writer;
        try {
            this.logger().trace("Uploading Artifact Chunk: " + vMArtifactChunk, new Object[0]);
            Response<String[]> response = this.client.getConnectionManager().sendVMArtifactChunk(vMArtifactChunk, outputStream -> dataWriter.writeData(new Utils.CountingOutputStream(outputStream, PerformanceMetrics::logArtifactBytes)));
            this.logger().trace("Upload finished " + (response.successful() ? "successfully" : "abnormally"), new Object[0]);
            if (!response.successful()) {
                throw new IOException("Failed to upload Artifact Chunk: " + vMArtifactChunk + ", with error: " + response.getError());
            }
        }
        catch (IOException iOException) {
            this.logger().error("An error occurred while uploading data: %s", iOException);
            dataWriter.handleException(iOException);
        }
    }

    private void discard(String string, Collection<Job> collection) {
        collection.forEach(job -> ((Job)job).writer.handleException(new RuntimeException("canceled")));
    }

    private static class Job {
        private final VMArtifactChunk chunk;
        private final DataWriter writer;

        public Job(VMArtifactChunk vMArtifactChunk, DataWriter dataWriter) {
            this.chunk = vMArtifactChunk;
            this.writer = dataWriter;
        }
    }
}

