/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Inventory;
import com.azul.crs.client.Utils;
import com.azul.crs.client.eventconsumer.VmEventConsumer;
import com.azul.crs.client.models.VMArtifact;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.util.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public final class VMLogMonitor
implements ClientService {
    private final ConcurrentHashMap<String, VMArtifactInfo> artifacts = new ConcurrentHashMap();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final VmEventConsumer eventConsumer;

    public static VMLogMonitor getInstance(VmEventConsumer vmEventConsumer) {
        return new VMLogMonitor(vmEventConsumer);
    }

    private VMLogMonitor(VmEventConsumer vmEventConsumer) {
        this.eventConsumer = vmEventConsumer;
    }

    @Override
    public void start() {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException(this.serviceName() + " is running already");
        }
    }

    @Override
    public void stop(Utils.Deadline deadline) {
        if (this.running.compareAndSet(true, false)) {
            this.logger().info("VMLogMonitor stopped.", new Object[0]);
            if (this.logger().isEnabled(Logger.Level.TRACE)) {
                for (Map.Entry<String, VMArtifactInfo> entry : this.artifacts.entrySet()) {
                    VMArtifactInfo vMArtifactInfo = entry.getValue();
                    this.logger().info("VMLog '%s' (%d) events: %,d; bytes: %,d", entry.getKey(), entry.getValue().id, vMArtifactInfo.eventsCount.get(), vMArtifactInfo.bytesSent.get());
                }
            }
        }
    }

    @Override
    public void terminate() {
        this.stop(Utils.Deadline.in(0L, TimeUnit.MILLISECONDS));
    }

    public void notifyVMLogEntry(String string, String string2) {
        if (!this.running.get()) {
            return;
        }
        VMArtifactInfo vMArtifactInfo = this.getVMArtifactInfo(string);
        try {
            int n = string2.length();
            long l = vMArtifactInfo.eventsCount.incrementAndGet();
            long l2 = vMArtifactInfo.bytesSent.addAndGet(n);
            this.eventConsumer.consumeVMArtifactData(vMArtifactInfo.id, string2);
            this.logger().trace("%d: Appended to VMLog artifact %s: size=%,d bytes, reported=%,d bytes", l, string, n, l2);
        }
        catch (Throwable throwable) {
            this.logger().warning("Exception occured: [%s] ", string, throwable);
        }
    }

    private VMArtifactInfo getVMArtifactInfo(String string) {
        return this.artifacts.computeIfAbsent(string, new VMArtifactInfoInitializer());
    }

    private class VMArtifactInfoInitializer
    implements Function<String, VMArtifactInfo> {
        private VMArtifactInfoInitializer() {
        }

        @Override
        public VMArtifactInfo apply(String string) {
            Integer n = VMLogMonitor.this.eventConsumer.createArtifactId();
            VMArtifactInfo vMArtifactInfo = new VMArtifactInfo(n);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", string);
            hashMap.put("tags", Inventory.instanceTags());
            VMLogMonitor.this.eventConsumer.consumeVMArtifactCreate(VMArtifact.Type.GC_LOG, n, hashMap);
            VMLogMonitor.this.logger().info("Created VMLog artifact %d for crsstream %s", n, string);
            return vMArtifactInfo;
        }
    }

    private static final class VMArtifactInfo {
        private final Integer id;
        private final AtomicLong eventsCount = new AtomicLong();
        private final AtomicLong bytesSent = new AtomicLong();

        public VMArtifactInfo(Integer n) {
            this.id = n;
        }
    }
}

