/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.util;

import com.azul.crs.util.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public class LRU<E> {
    private static AtomicLong overflowCounter = new AtomicLong();
    private final int sizeLimit;
    private int size;
    private Element<E> head;
    private Element<E> tail;
    private final Map<E, Element<E>> map;

    public static void dump() {
        Logger.getLogger(LRU.class).trace("overflow counter = %d", overflowCounter.get());
    }

    public LRU(int n, Consumer<E> consumer, Consumer<E> consumer2) {
        this.sizeLimit = n;
        final Consumer<E> consumer3 = consumer;
        final Consumer<E> consumer4 = consumer2;
        this.map = new HashMap<E, Element<E>>(){

            @Override
            public Element<E> put(E e, Element<E> element) {
                consumer3.accept(e);
                return super.put(e, element);
            }

            @Override
            public Element<E> remove(Object object) {
                consumer4.accept(object);
                return (Element)super.remove(object);
            }
        };
    }

    public LRU(int n) {
        this(n, null, null);
    }

    private void moveToTheHead(Element<E> element) {
        Element<E> element2 = this.head;
        Element<E> element3 = this.tail;
        Element element4 = element.prev;
        Element element5 = element.next;
        if (element == this.head) {
            return;
        }
        if (element == this.tail) {
            this.tail = element.prev;
            this.tail.next = this.tail;
        } else {
            element.next.prev = element.prev;
            element.prev.next = element.next;
        }
        element.prev = element;
        element.next = this.head;
        this.head.prev = element;
        this.head = element;
    }

    private void addToTheHead(E e) {
        if (this.size == 0) {
            this.tail = new Element<E>(e);
            this.head = this.tail;
            this.map.put(e, this.head);
            this.head.prev = this.head;
            this.tail.next = this.tail;
            ++this.size;
        } else if (this.size < this.sizeLimit) {
            Element<E> element = new Element<E>(e);
            this.map.put(e, element);
            element.prev = element;
            element.next = this.head;
            this.head.prev = element;
            this.head = element;
            ++this.size;
        } else {
            this.map.put(e, this.tail);
            this.map.remove(this.tail.data);
            this.tail.data = e;
            this.moveToTheHead(this.tail);
            overflowCounter.incrementAndGet();
        }
    }

    public synchronized boolean contains(E e) {
        return this.map.containsKey(e);
    }

    public synchronized void put(E e) {
        Element<E> element = this.map.get(e);
        if (element != null) {
            this.moveToTheHead(element);
        } else {
            this.addToTheHead(e);
        }
    }

    public static final class Element<E> {
        public E data;
        public Element<E> next;
        public Element<E> prev;

        public Element(E e) {
            this.data = e;
            this.next = null;
            this.prev = null;
        }
    }
}

