/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.datafilter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SensitiveDataFilterFactory {
    private static final String INV_ENV_ALLOW = "inventory.environment.allow";
    private static final String INV_ENV_DENY = "inventory.environment.deny";
    private static final String INV_SYS_PROPS_ALLOW = "inventory.system.properties.allow";
    private static final String INV_SYS_PROPS_DENY = "inventory.system.properties.deny";
    private final Properties props = new Properties();

    public SensitiveDataFilterFactory() {
        try (InputStream inputStream = SensitiveDataFilterFactory.class.getResourceAsStream("data-filter.properties");){
            if (inputStream == null) {
                throw new IllegalStateException("File not found: data-filter.properties");
            }
            this.props.load(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public Predicate<String> createSystemPropertyFilter() {
        return new PropertiesFilter((String)this.props.get(INV_SYS_PROPS_ALLOW), (String)this.props.get(INV_SYS_PROPS_DENY));
    }

    public Predicate<String> createEnvironmentFilter() {
        return new PropertiesFilter((String)this.props.get(INV_ENV_ALLOW), (String)this.props.get(INV_ENV_DENY));
    }

    private static class PropertiesFilter
    implements Predicate<String> {
        private final Set<String> allow;
        private final Set<String> deny;

        private PropertiesFilter(String string, String string2) {
            this.allow = Arrays.stream(string.split("\\|")).map(String::trim).collect(Collectors.toSet());
            this.deny = Arrays.stream(string2.split("\\|")).map(String::trim).collect(Collectors.toSet());
        }

        @Override
        public boolean test(String string) {
            return this.allow.contains(string) && !this.deny.contains(string);
        }
    }
}

