/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.util.logging;

import com.azul.crs.client.Tweaks;
import com.azul.crs.util.logging.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class LoggingHelper {
    private static AtomicInteger unhandledExceptionsCounter = new AtomicInteger();
    private static Set<String> knownExceptions = Collections.synchronizedSet(new HashSet());

    public static void logUnhandledException(Logger logger, Logger.Level level, Throwable throwable) {
        unhandledExceptionsCounter.incrementAndGet();
        if (logger == null || level == null || knownExceptions.size() >= Tweaks.dedupSize) {
            return;
        }
        try {
            String string = Objects.toString(throwable) + Arrays.stream(throwable.getStackTrace()).map(stackTraceElement -> Objects.toString(stackTraceElement)).collect(Collectors.joining(","));
            if (knownExceptions.contains(string)) {
                return;
            }
            knownExceptions.add(string);
            logger.log(level, "Unexpected exception %s", throwable);
        }
        catch (Throwable throwable2) {
            throwable2.printStackTrace();
        }
    }

    public static void logStatistics(Logger logger, Logger.Level level) {
        try {
            int n = unhandledExceptionsCounter.get();
            if (n == 0) {
                return;
            }
            logger.log(level, "%d exceptions were unhandled", n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

